<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Version information
 *
 * @package    local_saeko
 * @copyright 2023 Ivan G. {https://www.saeko.io}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_saeko\external;

use dml_exception;
use external_function_parameters;
use external_multiple_structure;
use external_single_structure;
use external_value;

defined('MOODLE_INTERNAL') || die();

require_once(__DIR__ . '/../../../../lib/externallib.php');

class get_filter extends \core_external\external_api
{
    /**
     * @return external_function_parameters
     */
    public static function execute_parameters(): external_function_parameters
    {
        return new external_function_parameters(
            array(
                'limit' => new external_value(PARAM_ALPHANUM, '0 - Get all or Get limit')
            )
        );
    }

    /**
     * @param int $limit
     * @return array
     * @throws dml_exception
     */
    public static function execute(int $limit): array
    {
        global $CFG, $DB;

        $badwords = [];
        $final_badwords = [];
        $lang = $DB->get_record('config', ['name' => 'lang'])->value;

        if (file_get_contents($CFG->dataroot . '/lang/' . $lang . '/filter_censor.php')) {
            require_once($CFG->dataroot . '/lang/' . $lang . '/filter_censor.php');
            $badwords = explode(', ', $string['badwords']);
        } else {
            $badwords = array('shit', 'fucked', 'fucker', 'fuck', 'dickhead', 'dick', 'cockhead', 'cock', 'cunt', 'asshole', 'arsehole', 'prick', 'bitch', 'jism', 'whore', 'slut', 'wanker', 'wank', 'bastard', 'dildo', 'masturbate', 'orgasm', 'penis', 'nigger', 'pussy', 'vagina');
        }

        foreach ($badwords as $key => $badword) {
            $arr['key'] = $key;
            $arr['value'] = $badword;
            $final_badwords[] = $arr;
        }

        return match ($limit) {
            0 => $final_badwords,
            default => array_slice($final_badwords, 0, $limit),
        };
    }

    /**
     * @return external_multiple_structure
     */
    public static function execute_returns(): external_multiple_structure
    {
        return new external_multiple_structure(
            new external_single_structure(
                array(
                    'key' => new external_value(PARAM_INT, 'Key text filter'),
                    'value' => new external_value(PARAM_TEXT, 'Value text filter'),
                )
            )
        );
    }
}