<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Version information
 *
 * @package    local_saeko
 * @copyright 2023 Ivan G. {https://www.saeko.io}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$functions = array(
    'core_saeko_external_apis_filter_censor' => array(
        'classname' => 'local_saeko\external\get_filter',
        'description' => 'Get all filter sensor',
    ),
    'core_saeko_external_apis_get_roles' => array(
        'classname' => 'local_saeko\external\get_roles',
        'description' => 'Get all role',
    ),
    'core_saeko_external_apis_check_status' => array(
        'classname' => 'local_saeko\external\check_connection',
        'description' => 'Check connection',
    ),
    'core_saeko_external_get_auths' => array(
        'classname' => 'local_saeko\external\get_auths',
        'description' => 'Get all auths',
    ),
);

$services = array(
    'SAEKO - Moodle web service' => array(
        'functions' => array(
            'core_course_get_categories',
            'core_course_create_categories',
            'core_course_update_categories',
            'core_course_delete_categories',
            'core_course_get_courses_by_field',
            'core_course_create_courses',
            'core_course_update_courses',
            'core_course_delete_courses',
            'core_course_duplicate_course',
            'core_course_import_course',
            'core_user_get_users_by_field',
            'core_user_create_users',
            'core_user_update_users',
            'core_user_delete_users',
            'enrol_manual_enrol_users',
            'enrol_manual_unenrol_users',
            'core_saeko_external_apis_check_status',
            'core_saeko_external_apis_filter_censor',
            'core_saeko_external_apis_get_roles',
            'gradereport_user_get_grade_items',
            'core_user_get_users',
            'core_saeko_external_get_auths',
        ),
        'enabled' => 1,
        'restrictedusers' => 0,
        'shortname' => 'SAEKO-MOODLE',
        'downloadfiles' => 1,
        'uploadfiles' => 1
    ),
);