<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Version information
 *
 * @package    local_saeko
 * @copyright 2024 Ivan G. {https://www.saeko.io}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_saeko\external;

use coding_exception;
use external_function_parameters;
use external_multiple_structure;
use external_single_structure;
use external_value;

defined('MOODLE_INTERNAL') || die();

require_once(__DIR__ . '/../../../../lib/externallib.php');

class get_auths extends \core_external\external_api
{
    /**
     * @return external_function_parameters
     */
    public static function execute_parameters(): external_function_parameters
    {
        return new external_function_parameters(
            array(
                'limit' => new external_value(PARAM_INT, '0 - Get actives or Get actives and inactives')
            )
        );
    }

    /**
     * @param int $limit
     * @return array|array[]
     * @throws coding_exception
     */
    public static function execute(int $limit): array
    {
        $result = array(
            'Enabled' => array(),
            'Disabled' => array()
        );

        $auth_plugins = get_enabled_auth_plugins(true);
        $auth_options = array();

        foreach ($auth_plugins as $auth) {
            $auth_options[$auth] = get_string('pluginname', "auth_{$auth}");
        }

        // Get all available authentication plugins.
        $all_plugins = \core_component::get_plugin_list('auth');

        foreach ($all_plugins as $plugin => $dir) {
            if (isset($auth_options[$plugin])) {
                $result['Enabled'][] = array(
                    'method' => $plugin,
                    'display_name' => $auth_options[$plugin]
                );
            } else {
                if ($limit !== 0) {
                    $result['Disabled'][] = array(
                        'method' => $plugin,
                        'display_name' => get_string('pluginname', "auth_{$plugin}")
                    );
                }
            }
        }

        return $result;
    }

    /**
     * @return external_single_structure
     */
    public static function execute_returns(): external_single_structure
    {
        return new external_single_structure(
            array(
                'Enabled' => new external_multiple_structure(
                    new external_single_structure(
                        array(
                            'method' => new external_value(PARAM_TEXT, 'Authentication method name'),
                            'display_name' => new external_value(PARAM_TEXT, 'Display name of the authentication method')
                        )
                    )
                ),
                'Disabled' => new external_multiple_structure(
                    new external_single_structure(
                        array(
                            'method' => new external_value(PARAM_TEXT, 'Authentication method name'),
                            'display_name' => new external_value(PARAM_TEXT, 'Display name of the authentication method')
                        )
                    )
                )
            )
        );
    }
}