<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Version information
 *
 * @package    local_saeko
 * @copyright 2023 Ivan G. {https://www.saeko.io}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_saeko\external;

use dml_exception;
use external_function_parameters;
use external_multiple_structure;
use external_single_structure;
use external_value;

defined('MOODLE_INTERNAL') || die();

require_once(__DIR__ . '/../../../../lib/externallib.php');

class get_roles extends \core_external\external_api
{
    /**
     * @return external_function_parameters
     */
    public static function execute_parameters(): external_function_parameters
    {
        return new external_function_parameters(
            array(
                'roleid' => new external_value(PARAM_ALPHANUM, '0 - Get all or Get for ID')
            )
        );
    }

    /**
     * @param int $roleid
     * @return array
     * @throws dml_exception
     */
    public static function execute(int $roleid): array
    {
        global $CFG, $DB;

        $roles = [];
        $final_roles = [];

        if ($roleid == 0) {
            $roles = $DB->get_records('role');
        } else {
            $roles = $DB->get_records('role', ['id' => $roleid]);
        }

        foreach ($roles as $key => $role) {
            $arr['id'] = $key;
            $arr['name'] = $role->name;
            $arr['shortname'] = $role->shortname;
            $arr['description'] = $role->description;
            $arr['sortorder'] = $role->sortorder;
            $arr['archetype'] = $role->archetype;
            $final_roles[] = $arr;
        }

        return $final_roles;
    }

    /**
     * @return external_multiple_structure
     */
    public static function execute_returns(): external_multiple_structure
    {
        return new external_multiple_structure(
            new external_single_structure(
                array(
                    'id' => new external_value(PARAM_INT, 'ID for Role'),
                    'name' => new external_value(PARAM_TEXT, 'Name Role'),
                    'shortname' => new external_value(PARAM_TEXT, 'SHORTNAME for Role'),
                    'description' => new external_value(PARAM_TEXT, 'DESCRIPTION for Role'),
                    'sortorder' => new external_value(PARAM_TEXT, 'SORTORDER for Role'),
                    'archetype' => new external_value(PARAM_TEXT, 'ARCHETYPE for role'),
                )
            )
        );
    }
}