<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Version information
 *
 * @package    local_saeko
 * @copyright 2023 Ivan G. {https://www.saeko.io}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_saeko\task;

use coding_exception;
use dml_exception;
use lang_string;

defined('MOODLE_INTERNAL') || die();

class check_course_sync extends \core\task\scheduled_task
{
    /**
     * @return lang_string|string
     * @throws coding_exception
     */
    public function get_name()
    {
        return get_string('task_course_sync', 'local_saeko');
    }

    /**
     * @return void
     * @throws dml_exception
     */
    public function execute()
    {
        global $DB;

        mtrace("Check course sync");

        if ($DB->get_records('saeko_log_create_course')) {

            $sql = "SELECT * FROM {logstore_standard_log}
                WHERE action = 'created'
                  AND component = 'core'
                  AND target = 'course'
                  AND objecttable = 'course'
                  AND objectid = ?";

            $syncs = $DB->get_records('saeko_log_create_course');

            foreach ($syncs as $sync) {
                if ($DB->get_record_sql($sql, array($sync->id_course))) {
                    if ($DB->get_record_sql($sql, array($sync->id_course))->origin == 'ws') {

                        if ($DB->get_record('saeko_log_create_course', array('id' => $sync->id))->sync_saeko_course == 0) {
                            $fila = $DB->get_record('saeko_log_create_course', array('id' => $sync->id));
                            $fila->sync_saeko_course = 1;
                            $fila->timeaction = time();
                            $DB->update_record('saeko_log_create_course', $fila);
                            mtrace("Update sync course $sync->id");
                        }

                    } else {
                        $DB->delete_records_select('saeko_log_create_course', 'id=?', [$sync->id]);
                        mtrace("Delete sync course $sync->id");
                    }
                }
            }
        }

        mtrace("Finish check category sync");
    }
}