<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Version information
 *
 * @package    local_saeko
 * @copyright 2023 Ivan G. {https://www.saeko.io}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_saeko;

use core\event\course_category_created;
use core\event\course_category_deleted;
use core\event\course_created;
use core\event\course_deleted;
use core\event\user_created;
use core\event\user_deleted;
use dml_exception;

defined('MOODLE_INTERNAL') || die();

/**
 * Función de eventos
 */
class event_handler
{
    /**
     * @param course_category_created $category_created
     * @return void
     * @throws dml_exception
     */
    public static function detail_category_created(course_category_created $category_created)
    {
        global $DB;

        $category = new \stdClass();
        $category->id_category = $category_created->objectid;
        $category->sync_saeko_category = 0;
        $category->timeaction = time();

        $DB->insert_record('saeko_log_create_category', $category);
    }

    /**
     * @param course_category_deleted $category_deleted
     * @return void
     * @throws dml_exception
     */
    public static function detail_category_deleted(course_category_deleted $category_deleted)
    {
        global $DB;

        if ($DB->get_record('saeko_log_create_category', array('id_category' => $category_deleted->objectid))) {

            $syn_cate = $DB->get_record('saeko_log_create_category', array('id_category' => $category_deleted->objectid));

            $DB->delete_records_select('saeko_log_create_category', 'id=?', [$syn_cate->id]);
        }
    }

    /**
     * @param course_created $course_created
     * @return void
     * @throws dml_exception
     */
    public static function detail_course_created(course_created $course_created)
    {
        global $DB;

        $course = new \stdClass();
        $course->id_course = $course_created->courseid;
        $course->sync_saeko_course = 0;
        $course->sync_saeko_course_info = json_encode($course_created->other);
        $course->timeaction = time();

        $DB->insert_record('saeko_log_create_course', $course);
    }

    /**
     * @param course_deleted $course_deleted
     * @return void
     * @throws dml_exception
     */
    public static function detail_course_deleted(course_deleted $course_deleted): void
    {
        global $DB;

        if ($DB->get_record('saeko_log_create_course', array('id_course' => $course_deleted->courseid))) {

            $syn_course = $DB->get_record('saeko_log_create_course', array('id_course' => $course_deleted->courseid));

            $DB->delete_records_select('saeko_log_create_course', 'id=?', [$syn_course->id]);
        }
    }

    /**
     * @param user_created $user_created
     * @return void
     * @throws dml_exception
     */
    public static function detail_user_created(user_created $user_created): void
    {
        global $DB;

        $user = new \stdClass();
        $user->id_user = $user_created->objectid;
        $user->sync_saeko_user = 0;
        $user->timeaction = time();

        $DB->insert_record('saeko_log_create_user', $user);
    }

    /**
     * @param user_deleted $user_deleted
     * @return void
     * @throws dml_exception
     */
    public static function detail_user_deleted(user_deleted $user_deleted): void
    {
        global $DB;

        if ($DB->get_record('saeko_log_create_user', array('id_user' => $user_deleted->objectid))) {

            $syn_user = $DB->get_record('saeko_log_create_user', array('id_user' => $user_deleted->objectid));

            $DB->delete_records_select('saeko_log_create_user', 'id=?', [$syn_user->id]);
        }
    }
}