<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Version information
 *
 * @package    local_saeko
 * @copyright 2023 Ivan G. {https://www.saeko.io}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$functions = array(
    'core_saeko_external_apis_filter_censor' => array(
        'classname' => 'core_saeko_external_apis',
        'methodname' => 'core_saeko_get_filter_censor',
        'classpath' => 'local/saeko/externallib.php',
        'description' => 'Get all filter sensor',
    ),
    'core_saeko_external_apis_get_roles' => array(
        'classname' => 'core_saeko_external_apis',
        'methodname' => 'core_saeko_get_roles',
        'classpath' => 'local/saeko/externallib.php',
        'description' => 'Get all role',
    ),
    'core_saeko_external_apis_check_status' => array(
        'classname' => 'core_saeko_external_apis',
        'methodname' => 'core_saeko_check_status',
        'classpath' => 'local/saeko/externallib.php',
        'description' => 'Check conection',
    ),
    'core_saeko_external_get_auths' => array(
        'classname' => 'core_saeko_external_apis',
        'methodname' => 'core_saeko_get_auths',
        'classpath' => 'local/saeko/externallib.php',
        'description' => 'Get auths',
    ),
);

$services = array(
    'SAEKO - Moodle web service' => array(
        'functions' => array(
            'core_course_get_categories',
            'core_course_create_categories',
            'core_course_update_categories',
            'core_course_delete_categories',
            'core_course_get_courses_by_field',
            'core_course_create_courses',
            'core_course_update_courses',
            'core_course_delete_courses',
            'core_course_duplicate_course',
            'core_course_import_course',
            'core_user_get_users_by_field',
            'core_user_create_users',
            'core_user_update_users',
            'core_user_delete_users',
            'enrol_manual_enrol_users',
            'enrol_manual_unenrol_users',
            'core_saeko_external_apis_check_status',
            'core_saeko_external_apis_filter_censor',
            'core_saeko_external_apis_get_roles',
            'gradereport_user_get_grade_items',
            'core_user_get_users',
            'core_saeko_external_get_auths',
        ),
        'enabled' => 1,
        'restrictedusers' => 0,
        'shortname' => 'SAEKO-MOODLE',
        'downloadfiles' => 1,
        'uploadfiles' => 1
    ),
);