<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Version information
 *
 * @package    local_saeko
 * @copyright 2023 Ivan G. {https://www.saeko.io}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once('../../config.php');

/**
 * LLamado de APIS
 */
class core_saeko_external_apis extends external_api
{
    /**
     * Returns description of method parameters
     *
     * @return external_function_parameters
     * @since Moodle 2.2
     */
    public static function core_saeko_get_filter_censor_parameters(): external_function_parameters
    {
        return new external_function_parameters(
            array(
                'limit' => new external_value(PARAM_ALPHANUM, '0 - Get all or Get limit')
            )
        );
    }

    /**
     * Get Filter Censor
     *
     * @param int $limit 0 - Get all or Get limit
     * @return array $results The array of results.
     * @throws dml_exception
     * @since Moodle 2.2
     */
    public static function core_saeko_get_filter_censor(int $limit): array
    {
        global $CFG, $DB;

        $badwords = [];
        $final_badwords = [];
        $lang = $DB->get_record('config', ['name' => 'lang'])->value;

        if (file_get_contents($CFG->dataroot . '/lang/' . $lang . '/filter_censor.php')) {
            require_once($CFG->dataroot . '/lang/' . $lang . '/filter_censor.php');
            $badwords = explode(', ', $string['badwords']);
        } else {
            $badwords = array('shit', 'fucked', 'fucker', 'fuck', 'dickhead', 'dick', 'cockhead', 'cock', 'cunt', 'asshole', 'arsehole', 'prick', 'bitch', 'jism', 'whore', 'slut', 'wanker', 'wank', 'bastard', 'dildo', 'masturbate', 'orgasm', 'penis', 'nigger', 'pussy', 'vagina');
        }

        foreach ($badwords as $key => $badword) {
            $arr['key'] = $key;
            $arr['value'] = $badword;
            $final_badwords[] = $arr;
        }

        return match ($limit) {
            0 => $final_badwords,
            default => array_slice($final_badwords, 0, $limit),
        };
    }

    /**
     * Returns description of method result value
     *
     * @return external_description
     * @since Moodle 2.2
     */
    public static function core_saeko_get_filter_censor_returns()
    {
        return new external_multiple_structure(
            new external_single_structure(
                array(
                    'key' => new external_value(PARAM_INT, 'Key text filter'),
                    'value' => new external_value(PARAM_TEXT, 'Value text filter'),
                )
            )
        );
    }

    /**
     * Returns description of method parameters
     *
     * @return external_function_parameters
     * @since Moodle 2.2
     */
    public static function core_saeko_get_roles_parameters(): external_function_parameters
    {
        return new external_function_parameters(
            array(
                'roleid' => new external_value(PARAM_ALPHANUM, '0 - Get all or Get for ID')
            )
        );
    }

    /**
     * Get Filter Censor
     *
     * @param int $roleid 0 - Get all or Get for ID
     * @return array $results The array of results.
     * @throws dml_exception
     * @since Moodle 2.2
     */
    public static function core_saeko_get_roles(int $roleid): array
    {
        global $CFG, $DB;

        $roles = [];
        $final_roles = [];

        if ($roleid == 0) {
            $roles = $DB->get_records('role');
        } else {
            $roles = $DB->get_records('role', ['id' => $roleid]);
        }

        foreach ($roles as $key => $role) {
            $arr['id'] = $key;
            $arr['name'] = $role->name;
            $arr['shortname'] = $role->shortname;
            $arr['description'] = $role->description;
            $arr['sortorder'] = $role->sortorder;
            $arr['archetype'] = $role->archetype;
            $final_roles[] = $arr;
        }

        return $final_roles;
    }

    /**
     * Returns description of method result value
     *
     * @return external_description
     * @since Moodle 2.2
     */
    public static function core_saeko_get_roles_returns()
    {
        return new external_multiple_structure(
            new external_single_structure(
                array(
                    'id' => new external_value(PARAM_INT, 'ID for Role'),
                    'name' => new external_value(PARAM_TEXT, 'Name Role'),
                    'shortname' => new external_value(PARAM_TEXT, 'SHORTNAME for Role'),
                    'description' => new external_value(PARAM_TEXT, 'DESCRIPTION for Role'),
                    'sortorder' => new external_value(PARAM_TEXT, 'SORTORDER for Role'),
                    'archetype' => new external_value(PARAM_TEXT, 'ARCHETYPE for role'),
                )
            )
        );
    }

    /**
     * Returns description of method parameters
     *
     * @return external_function_parameters
     * @since Moodle 2.2
     */
    public static function core_saeko_check_status_parameters(): external_function_parameters
    {
        return new external_function_parameters(
            array(
                'check' => new external_value(PARAM_INT, '0 or 1 check conection')
            )
        );
    }

    /**
     * Get Filter Censor
     *
     * @param int $check True or False check connection
     * @return array $results The array of results.
     * @since Moodle 2.2
     */
    public static function core_saeko_check_status(int $check): array
    {
        $arr['status'] = 1;

        return $arr;
    }

    /**
     * Returns description of method result value
     *
     * @return external_description
     * @since Moodle 2.2
     */
    public static function core_saeko_check_status_returns()
    {
        return new external_single_structure(
            array(
                'status' => new external_value(PARAM_INT, 'Status conection'),
            )
        );
    }

    public static function core_saeko_get_auths_parameters(): external_function_parameters
    {
        return new external_function_parameters(
            array(
                'limit' => new external_value(PARAM_INT, '0 - Get actives or Get actives and inactives')
            )
        );
    }

    public static function core_saeko_get_auths(int $limit): array
    {
        $result = array(
            'Enabled' => array(),
            'Disabled' => array()
        );

        $auth_plugins = get_enabled_auth_plugins(true);
        $auth_options = array();

        foreach ($auth_plugins as $auth) {
            $auth_options[$auth] = get_string('pluginname', "auth_{$auth}");
        }

        // Get all available authentication plugins.
        $all_plugins = \core_component::get_plugin_list('auth');

        foreach ($all_plugins as $plugin => $dir) {
            if (isset($auth_options[$plugin])) {
                $result['Enabled'][] = array(
                    'method' => $plugin,
                    'display_name' => $auth_options[$plugin]
                );
            } else {
                if ($limit !== 0) {
                    $result['Disabled'][] = array(
                        'method' => $plugin,
                        'display_name' => get_string('pluginname', "auth_{$plugin}")
                    );
                }
            }
        }

        return $result;
    }

    public static function core_saeko_get_auths_returns()
    {
        return new external_single_structure(
            array(
                'Enabled' => new external_multiple_structure(
                    new external_single_structure(
                        array(
                            'method' => new external_value(PARAM_TEXT, 'Authentication method name'),
                            'display_name' => new external_value(PARAM_TEXT, 'Display name of the authentication method')
                        )
                    )
                ),
                'Disabled' => new external_multiple_structure(
                    new external_single_structure(
                        array(
                            'method' => new external_value(PARAM_TEXT, 'Authentication method name'),
                            'display_name' => new external_value(PARAM_TEXT, 'Display name of the authentication method')
                        )
                    )
                )
            )
        );
    }
}